/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspSimpleCmds;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class BpaSimpleCmds {
    private static BpaSimpleCmds mInst;
    private static final String BPA_GET_BPC_STATE = "BPA_GET_BPC_STATE";
    private static final String BPA_HEADER = "BPA_HEADER";
    private static final String BPC_STATE = "BPC_STATE";
    private static final String RETURN_CODE = "RETURN_CODE";
    private static final String BPA_GET_FRAME_NUM = "BPA_GET_FRAME_NUM";
    private static final String FRAME_NUM = "FRAME_NUM";
    private static final String BPA_SET_FRAME_NUM = "BPA_SET_FRAME_NUM";
    private static final String BPA_SET_BPC_NAME = "BPA_SET_BPC_NAME";
    private static final String BPA_GET_ENV_INFO = "BPA_GET_ENV_INFO";
    private static final String VOLT_AB = "VOLT_AB";
    private static final String VOLT_BC = "VOLT_BC";
    private static final String VOLT_CA = "VOLT_CA";
    private static final String AMPS_A = "AMPS_A";
    private static final String AMPS_B = "AMPS_B";
    private static final String AMPS_C = "AMPS_C";
    private static final String BPA_SET_LOCK = "BPA_SET_LOCK";
    private static final String BPA_CLEAR_LOCK = "BPA_CLEAR_LOCK";
    private static final String BPA_QUERY_LOCK = "BPA_QUERY_LOCK";
    private static final String BPA_RESET_LOCK = "BPA_RESET_LOCK";
    private static final String BPA_QUERY_FRU_REDUNDANCY = "BPA_QUERY_FRU_REDUNDANCY";
    private static final String BPA_DEACTIVATE_FRU = "BPA_DEACTIVATE_FRU";
    private static final String BPA_ACTIVATE_FRU = "BPA_ACTIVATE_FRU";
    private static final String BPA_START_ACDL = "BPA_START_ACDL";
    private static final String BPA_POWERON_CAGE = "BPA_POWERON_CAGE";
    private static final String BPA_POWEROFF_CAGE = "BPA_POWEROFF_CAGE";
    private static final String BPA_POWERON_UNOWNEDCAGE = "BPA_POWERON_UNOWNEDCAGE";
    private static final String BPA_POWER_ON_CAGE_LC = "BPA_POWER_ON_CAGE_LC";
    private static final String BPA_ADD_DRAWER = "BPA_ADD_DRAWER";
    private static final String BPA_REMOVE_DRAWER = "BPA_REMOVE_DRAWER";

    static BpaSimpleCmds getInstance() {
        if (mInst == null) {
            mInst = new BpaSimpleCmds();
        }
        return mInst;
    }

    UnsignedInt8 getBpcStateCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        int n = -1660944384;
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_GET_BPC_STATE, new String[]{"" + n}, 0);
        return (UnsignedInt8)hashtable.get(BPC_STATE);
    }

    UnsignedInt16 getFrameNumberCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        int n = 0x64000000;
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_GET_FRAME_NUM, new String[]{"" + n}, 0);
        return new UnsignedInt16(hashtable.get(FRAME_NUM).toString());
    }

    void setFrameNumberCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException {
        int n = 0x63000000;
        fSPCmdMgr.doBPACommand(BPA_SET_FRAME_NUM, new String[]{"" + n, unsignedInt16.toString()}, 0);
    }

    void setBpcNameCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        String string2 = ByteUtilities.toHexString(FspSimpleCmds.javaToFSPString(string));
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(BPA_SET_BPC_NAME, new String[]{string2}, 0);
    }

    UnsignedInt16[] getEnvironmentalInfoCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        int n = 0x26000002;
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_GET_ENV_INFO, new String[]{"" + n}, 0);
        if (hashtable == null) {
            System.out.println("Error in Get Environmental Info cmd..");
            return null;
        }
        UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{(UnsignedInt16)hashtable.get(VOLT_AB), (UnsignedInt16)hashtable.get(VOLT_BC), (UnsignedInt16)hashtable.get(VOLT_CA), (UnsignedInt16)hashtable.get(AMPS_A), (UnsignedInt16)hashtable.get(AMPS_B), (UnsignedInt16)hashtable.get(AMPS_C)};
        return unsignedInt16Array;
    }

    UnsignedInt8 bpaSetLockCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException {
        int n = 0x13000000;
        String string2 = Integer.toString(n);
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        System.out.println("length of HMC Mtms: " + unsignedInt16);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_SET_LOCK, new String[]{string2, unsignedInt16.toString(), string}, 0);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    UnsignedInt8 bpaClearLockCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException {
        int n = 0x13000001;
        String string2 = Integer.toString(n);
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string.length());
        System.out.println("length of HMC Mtms: " + unsignedInt16);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_CLEAR_LOCK, new String[]{string2, unsignedInt16.toString(), string}, 0);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    Hashtable bpaQueryLockCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        int n = 318767106;
        String string = Integer.toString(n);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_QUERY_LOCK, new String[]{string}, 0);
        return hashtable;
    }

    UnsignedInt8 bpaResetLockCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        int n = 0x13000003;
        String string = Integer.toString(n);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_RESET_LOCK, new String[]{string}, 0);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    UnsignedInt8 queryRedundancyCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException {
        int n = -1694498560;
        String string2 = Integer.toString(n);
        UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)(string.length() + 1));
        System.out.println("length of location code: " + unsignedInt8);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_QUERY_FRU_REDUNDANCY, new String[]{string2, unsignedInt8.toString(), string}, 0);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    UnsignedInt8 deactivateFruCmd(FSPCmdMgr fSPCmdMgr, String string, String string2) throws PIHscServerException {
        int n = 0x10000100;
        String string3 = Integer.toString(n);
        UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)(string.length() + 1));
        System.out.println("length of location code: " + unsignedInt8);
        Hashtable hashtable = null;
        hashtable = string2 == null ? fSPCmdMgr.doBPACommand(BPA_DEACTIVATE_FRU, new String[]{string3, unsignedInt8.toString(), string}, 0) : fSPCmdMgr.doBPACommand(BPA_DEACTIVATE_FRU, new String[]{string3, unsignedInt8.toString(), string}, 0, 1, string2);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    UnsignedInt8 activateFruCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException {
        int n = 0x11000101;
        String string2 = Integer.toString(n);
        UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)(string.length() + 1));
        System.out.println("length of location code: " + unsignedInt8);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_ACTIVATE_FRU, new String[]{string2, unsignedInt8.toString(), string}, 0);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    UnsignedInt8 startACDLCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException {
        int n = -1610612735;
        String string2 = Integer.toString(n);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_START_ACDL, new String[]{string2}, 0, 1, string);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    void powerOnCageCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException {
        int n = -2113929216;
        fSPCmdMgr.doBPACommand(BPA_POWERON_CAGE, new String[]{"" + n, unsignedInt8.toString()}, 0);
    }

    void powerOffCageCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException {
        int n = -2130706432;
        fSPCmdMgr.doBPACommand(BPA_POWEROFF_CAGE, new String[]{"" + n, unsignedInt8.toString()}, 0);
    }

    void powerOnUnownedCageCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        int n = -2113929200;
        fSPCmdMgr.doBPACommand(BPA_POWERON_UNOWNEDCAGE, new String[]{"" + n}, 0);
    }

    UnsignedInt8 powerOnCageLocCodeCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException {
        int n = -2113928960;
        String string2 = Integer.toString(n);
        UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)(string.length() + 1));
        System.out.println("length of location code: " + unsignedInt8);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_POWER_ON_CAGE_LC, new String[]{string2, unsignedInt8.toString(), string}, 0);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    UnsignedInt8 addDrawerCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException {
        int n = 0x41000100;
        String string2 = Integer.toString(n);
        UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)(string.length() + 1));
        System.out.println("length of location code: " + unsignedInt8);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_ADD_DRAWER, new String[]{string2, unsignedInt8.toString(), string}, 0);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }

    UnsignedInt8 removeDrawerCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException {
        int n = 0x40000100;
        String string2 = Integer.toString(n);
        UnsignedInt8 unsignedInt8 = new UnsignedInt8((short)(string.length() + 1));
        System.out.println("length of location code: " + unsignedInt8);
        Hashtable hashtable = fSPCmdMgr.doBPACommand(BPA_REMOVE_DRAWER, new String[]{string2, unsignedInt8.toString(), string}, 0);
        return (UnsignedInt8)hashtable.get(RETURN_CODE);
    }
}

